/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.items.ColorableItem;
import net.geforcemods.securitycraft.misc.GlobalPos;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FrameBlockEntityRenderer
extends TileEntitySpecialRenderer<FrameBlockEntity> {
    private static final ResourceLocation CAMERA_NOT_FOUND = new ResourceLocation("securitycraft", "textures/entity/frame/camera_not_found.png");
    private static final ResourceLocation INACTIVE = new ResourceLocation("securitycraft", "textures/entity/frame/inactive.png");
    private static final ResourceLocation NO_REDSTONE_SIGNAL = new ResourceLocation("securitycraft", "textures/entity/frame/no_redstone_signal.png");
    private static final ResourceLocation NOISE_BACKGROUND = new ResourceLocation("securitycraft", "entity/frame/noise_background");
    private static final ResourceLocation SELECT_CAMERA = new ResourceLocation("securitycraft", "textures/entity/frame/select_camera.png");
    private static final ResourceLocation WHITE = new ResourceLocation("securitycraft", "textures/entity/frame/white.png");

    public void render(FrameBlockEntity be, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Vector4f outerVertices;
        Vector4f innerVertices;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (be.isDisabled() || !be.isOwnedBy((Entity)player) && !be.isAllowed((Entity)player) || be.getCameraPositions().isEmpty()) {
            return;
        }
        World level = be.func_145831_w();
        IBlockState state = be.getBlockState();
        GlobalPos cameraPos = be.getCurrentCamera();
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FrameBlock.FACING);
        Vec3i normal = direction.func_176730_m();
        float margin = 0.0625f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        switch (direction) {
            case NORTH: {
                innerVertices = new Vector4f(0.0625f, 0.9375f, 0.05f, 0.05f);
                outerVertices = new Vector4f(0.0625f, 0.9375f, 0.045f, 0.045f);
                break;
            }
            case SOUTH: {
                innerVertices = new Vector4f(0.9375f, 0.0625f, 0.95f, 0.95f);
                outerVertices = new Vector4f(0.9375f, 0.0625f, 0.955f, 0.955f);
                break;
            }
            case WEST: {
                innerVertices = new Vector4f(0.05f, 0.05f, 0.9375f, 0.0625f);
                outerVertices = new Vector4f(0.045f, 0.045f, 0.9375f, 0.0625f);
                break;
            }
            case EAST: {
                innerVertices = new Vector4f(0.95f, 0.95f, 0.0625f, 0.9375f);
                outerVertices = new Vector4f(0.955f, 0.955f, 0.0625f, 0.9375f);
                break;
            }
            default: {
                innerVertices = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
                outerVertices = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
            }
        }
        if (cameraPos == null) {
            this.renderSolidTexture(SELECT_CAMERA, innerVertices, normal, 0.0625f);
        } else if (be.redstoneSignalDisabled()) {
            this.renderNoise(innerVertices, normal, 0.0625f);
            this.renderCutoutTexture(NO_REDSTONE_SIGNAL, outerVertices, normal, 0.0625f);
        } else if (!be.hasClientInteracted()) {
            this.renderNoise(innerVertices, normal, 0.0625f);
            this.renderCutoutTexture(INACTIVE, outerVertices, normal, 0.0625f);
        } else {
            CameraFeed feed = FrameFeedHandler.getFeed(cameraPos);
            if (!(feed != null && feed.isFrameLinked(be) && level.func_175667_e(cameraPos.pos()) && level.func_175625_s(cameraPos.pos()) instanceof SecurityCameraBlockEntity)) {
                this.renderSolidTexture(CAMERA_NOT_FOUND, innerVertices, normal, 0.0625f);
            } else if (!FrameFeedHandler.isCapturingCamera()) {
                SecurityCameraBlockEntity cameraBlockEntity = (SecurityCameraBlockEntity)level.func_175625_s(cameraPos.pos());
                Framebuffer target = feed.renderTarget();
                Tessellator tessellator = Tessellator.func_178181_a();
                float xStart = innerVertices.x;
                float xEnd = innerVertices.y;
                float zStart = innerVertices.z;
                float zEnd = innerVertices.w;
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                Vector3f backgroundColor = feed.backgroundColor();
                GlStateManager.func_179140_f();
                GlStateManager.func_179118_c();
                this.renderOverlay(innerVertices, (int)(backgroundColor.x * 255.0f), (int)(backgroundColor.y * 255.0f), (int)(backgroundColor.z * 255.0f), 255, normal, 0.0625f);
                target.func_147612_c();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferBuilder.func_181662_b((double)xStart, 0.0625, (double)zStart).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)xStart, 0.9375, (double)zStart).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)xEnd, 0.9375, (double)zEnd).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferBuilder.func_181662_b((double)xEnd, 0.0625, (double)zEnd).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
                tessellator.func_78381_a();
                target.func_147606_d();
                ItemStack lens = cameraBlockEntity.getLensContainer().func_70301_a(0);
                if (lens.func_77973_b() instanceof ColorableItem && ((ColorableItem)lens.func_77973_b()).hasColor(lens)) {
                    this.renderOverlay(innerVertices, ((ColorableItem)lens.func_77973_b()).getColor(lens) + (cameraBlockEntity.getOpacity() << 24), normal, 0.0625f);
                }
                GlStateManager.func_179141_d();
                GlStateManager.func_179145_e();
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderNoise(Vector4f vertices, Vec3i normal, float margin) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(NOISE_BACKGROUND.toString());
        this.renderTexture(TextureMap.field_110575_b, vertices, sprite.func_94209_e(), sprite.func_94206_g(), sprite.func_94212_f(), sprite.func_94210_h(), 255, 255, 255, 255, normal, margin);
    }

    private void renderSolidTexture(ResourceLocation texture, Vector4f vertices, Vec3i normal, float margin) {
        this.renderTexture(texture, vertices, 0.0f, 0.0f, 1.0f, 1.0f, 255, 255, 255, 255, normal, margin);
    }

    private void renderCutoutTexture(ResourceLocation texture, Vector4f vertices, Vec3i normal, float margin) {
        GlStateManager.func_179147_l();
        this.renderTexture(texture, vertices, 0.0f, 0.0f, 1.0f, 1.0f, 255, 255, 255, 255, normal, margin);
        GlStateManager.func_179084_k();
    }

    private void renderOverlay(Vector4f vertices, int color, Vec3i normal, float margin) {
        this.renderOverlay(vertices, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24, normal, margin);
    }

    private void renderOverlay(Vector4f vertices, int r, int g, int b, int a, Vec3i normal, float margin) {
        GlStateManager.func_179147_l();
        this.renderTexture(WHITE, vertices, 0.0f, 0.0f, 1.0f, 1.0f, r, g, b, a, normal, margin);
        GlStateManager.func_179084_k();
    }

    private void renderTexture(ResourceLocation texture, Vector4f vertices, float u0, float v0, float u1, float v1, int r, int g, int b, int a, Vec3i normal, float margin) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        float xStart = vertices.x;
        float xEnd = vertices.y;
        float zStart = vertices.z;
        float zEnd = vertices.w;
        int nx = normal.func_177958_n();
        int ny = normal.func_177956_o();
        int nz = normal.func_177952_p();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        bufferBuilder.func_181662_b((double)xStart, (double)margin, (double)zStart).func_187315_a((double)u1, (double)v1).func_181669_b(r, g, b, a).func_181663_c((float)nx, (float)ny, (float)nz).func_181675_d();
        bufferBuilder.func_181662_b((double)xStart, (double)(1.0f - margin), (double)zStart).func_187315_a((double)u1, (double)v0).func_181669_b(r, g, b, a).func_181663_c((float)nx, (float)ny, (float)nz).func_181675_d();
        bufferBuilder.func_181662_b((double)xEnd, (double)(1.0f - margin), (double)zEnd).func_187315_a((double)u0, (double)v0).func_181669_b(r, g, b, a).func_181663_c((float)nx, (float)ny, (float)nz).func_181675_d();
        bufferBuilder.func_181662_b((double)xEnd, (double)margin, (double)zEnd).func_187315_a((double)u0, (double)v1).func_181669_b(r, g, b, a).func_181663_c((float)nx, (float)ny, (float)nz).func_181675_d();
        tessellator.func_78381_a();
    }
}

